/*
 * Decompiled with CFR 0.152.
 */
package org.bluray.ti.selection;

import java.util.LinkedList;
import javax.tv.locator.InvalidLocatorException;
import javax.tv.locator.Locator;
import javax.tv.service.SIManager;
import javax.tv.service.Service;
import javax.tv.service.selection.InvalidServiceComponentException;
import javax.tv.service.selection.NormalContentEvent;
import javax.tv.service.selection.PresentationChangedEvent;
import javax.tv.service.selection.PresentationTerminatedEvent;
import javax.tv.service.selection.SelectionFailedEvent;
import javax.tv.service.selection.ServiceContentHandler;
import javax.tv.service.selection.ServiceContextDestroyedEvent;
import javax.tv.service.selection.ServiceContextEvent;
import javax.tv.service.selection.ServiceContextListener;
import org.bluray.ti.Title;
import org.bluray.ti.TitleImpl;
import org.bluray.ti.selection.TitleContext;
import org.videolan.BDJListeners;
import org.videolan.BDJLoader;
import org.videolan.BDJLoaderCallback;
import org.videolan.media.content.playlist.Handler;

public class TitleContextImpl
implements TitleContext {
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_DESTROYED = 2;
    private BDJListeners listeners = new BDJListeners();
    private LinkedList handlers = new LinkedList();
    private TitleImpl title = null;
    private int state = 0;

    public Service getService() {
        return this.title;
    }

    public ServiceContentHandler[] getServiceContentHandlers() throws SecurityException {
        if (this.state == 2) {
            throw new IllegalStateException();
        }
        if (this.state == 0) {
            return new ServiceContentHandler[0];
        }
        ServiceContentHandler[] handler = new ServiceContentHandler[]{new Handler()};
        return handler;
    }

    public void start(Title title, boolean restart) throws SecurityException {
        if (this.state == 2) {
            throw new IllegalStateException();
        }
        TitleStartAction action = new TitleStartAction(this, (TitleImpl)title);
        if (!BDJLoader.load((TitleImpl)title, restart, action)) {
            action.loaderDone(false);
        }
    }

    public void select(Service service) throws SecurityException {
        this.start((Title)service, true);
    }

    public void select(Locator[] locators) throws InvalidLocatorException, InvalidServiceComponentException, SecurityException {
        this.select(SIManager.createInstance().getService(locators[0]));
    }

    public void stop() throws SecurityException {
        if (this.state == 2) {
            throw new IllegalStateException();
        }
        TitleStopAction action = new TitleStopAction(this);
        if (!BDJLoader.unload(action)) {
            action.loaderDone(false);
        }
    }

    public void destroy() throws SecurityException {
        if (this.state != 2) {
            this.state = 2;
            TitleStopAction action = new TitleStopAction(this);
            if (!BDJLoader.unload(action)) {
                action.loaderDone(false);
            }
        }
    }

    public void addListener(ServiceContextListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ServiceContextListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceContentHandler(ServiceContentHandler handler) {
        if (handler != null) {
            LinkedList linkedList = this.handlers;
            synchronized (linkedList) {
                this.handlers.remove(handler);
            }
        }
    }

    public void presentationChanged() {
        if (this.state == 1) {
            this.postEvent(new PresentationChangedEvent(this));
        }
    }

    private void postEvent(ServiceContextEvent event) {
        this.listeners.putCallback(event);
    }

    private class TitleStopAction
    implements BDJLoaderCallback {
        private TitleContextImpl context;

        private TitleStopAction(TitleContextImpl context) {
            this.context = context;
        }

        public void loaderDone(boolean succeed) {
            if (succeed) {
                this.context.postEvent(new PresentationTerminatedEvent(this.context, 5));
                if (this.context.state == 2) {
                    this.context.postEvent(new ServiceContextDestroyedEvent(this.context));
                } else {
                    this.context.state = 0;
                }
            } else {
                this.context.postEvent(new SelectionFailedEvent(this.context, 255));
            }
        }
    }

    private class TitleStartAction
    implements BDJLoaderCallback {
        private TitleContextImpl context;
        private TitleImpl title;

        private TitleStartAction(TitleContextImpl context, TitleImpl title) {
            this.context = context;
            this.title = title;
        }

        public void loaderDone(boolean succeed) {
            if (succeed) {
                this.context.title = this.title;
                this.context.state = 1;
                this.context.postEvent(new NormalContentEvent(this.context));
            } else {
                this.context.postEvent(new SelectionFailedEvent(this.context, 255));
            }
        }
    }
}

